// Share.cpp: implementation of the CShare class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Share.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


HANDLE			g_hCOM;
CString			StrTmp;
char			*RetString;
unsigned char	Buffer[512];
unsigned char	DeviceAddr;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CShare::CShare()
{
}

CShare::~CShare()
{
}


// ̬APIسֵת
char * CShare::Api_Error(int RetStatus)
{
	switch (RetStatus) {
	case 0x00:
		RetString = "Command Operate Successfully";
		break;
	case 0x01:	
		if (Buffer[0] != 0x80) 
			RetString = "operating failed";
		break;
	case 0x02:
		RetString = "data length received not matching up";
		break;
	case 0x03:
		RetString = "serial port transmitting failed";
		break;
	case 0x04:
		RetString = "no data received by serial port";
		break;
	case 0x05:
		RetString = "device address not matching up";
		break;
	case 0x07:
		RetString = "checksum error";
		break;
	case 0x0A:
		RetString = "input parameter error, please refer to unspecific functions declaration";
		break;
	default:
		RetString = "undefined operation mistake";
		break;
	}
	
	return RetString;
}

// reader status return code transform
char * CShare::Return_CodeError(unsigned char RetError)
{
	switch(RetError) { 
	case 0x01:	
		RetString = "01  CMD operation faileddetail description please refer to functions";
		break;
	case 0x80:	
		RetString = "80  parameter setup succeed";
		break;
	case 0x81:	
		RetString = "81  parameter setup failed";
		break;
	case 0x82:	
		RetString = "82  communication timeout";
		break;
	case 0x83:	
		RetString = "83  no card existing";
		break;
	case 0x84:	
		RetString = "84  data of card received error";
		break;
	case 0x85:	
		RetString = "85  input parameter or input CMD format error";
		break;
	case 0x87:	
		RetString = "87  unknown error";
		break;
	case 0x89:
		RetString = "89  input parameter or input CMD format error";
		break;
	case 0x8A:	
		RetString = "8A  blocks initializing mistake";
		break;
	case 0x8B:	
		RetString = "8B  anti-collision error";
		break;
	case 0x8C:	
		RetString = "8C  authentication error";
		break;
	case 0x8f:	
		RetString = "8F  input CMD code not existing";
		break;
	case 0x90:	
		RetString = "90  command not supported by card";
		break;
	case 0x91:	
		RetString = "91  command format mistake";	
		break;
	case 0x92:
		RetString = "92  OPTION mode not available under this FLAG";
		break;
	case 0x93:	
		RetString = "93  BLOCK to be operated not existing";
		break;
	case 0x94:	
		RetString = "94  Block had been locked and not revisable";
		break;
	case 0x95:	
		RetString = "95  Block locking failed";
		break;
	case 0x96:	
		RetString = "96  Block writing failed";
		break;
	default:
		sprintf(RetString, "%02X  undefined operation mistake", RetError);
		break;
	}

	return RetString;
}

void CShare::WriteToResult(CString Str, CString &ResultStr)
{
	CString tmpStr;
	CTime t = CTime::GetCurrentTime();

	tmpStr.Format(_T("\r\n%d-%d-%d  %02d:%02d:%02d "), t.GetYear(), t.GetMonth(), t.GetDay(), t.GetHour(), t.GetMinute(), t.GetSecond());
	ResultStr += _T("\r\n") + Str;
	ResultStr += tmpStr;
	ResultStr += _T("\r\n------------------------------------------------------------");
//	ResultStr = tmpStr + ResultStr;
//	ResultStr = _T("\r\n") + ResultStr;
//	ResultStr = Str + ResultStr;
//	ResultStr = ResultStr + _T("\r\n");
	return;
}


// ȥַз16Ƶַ
unsigned char * CShare::StrtoHEXStr(unsigned char *inString)
{
	unsigned char	outString[1024];
	int				i, j;
	
	for (i = 0, j = 0; (*inString != '\0') && (i < (int) strlen((char *)inString)); i++) {
		if ( (*(inString+i) >= 'a' && *(inString+i) <= 'f')  || (*(inString+i) >= 'A' && *(inString+i) <= 'F')  || isdigit(*(inString+i)) || *(inString+i) == 0 ) {
			outString[j++] = *(inString + i);
		}
	}
	outString[j] = '\0';
	
	return &outString[0];
}

// ʮַתΪʮ
unsigned char * CShare::ChartoUChar(unsigned char * str)
{
    unsigned char	temp[3];
	unsigned char	uchar[256];
	
	temp[2] = 0;
	for (int i = 0; i < (int)strlen((char *)str); i++) {
		temp[0] = *(str + 2*i);
		temp[1]	= *(str + 2*i + 1);
		uchar[i] = (unsigned char) strtol((char *)temp, NULL, 16);
	}
    //uchar[i] = '\0';
	return &uchar[0];
}

// 16ַת10ƴ
int CShare::OXStrtoD(unsigned char *String)
{
	unsigned char *CharTemp = StrtoHEXStr(String);
	int len = strlen( (char *)CharTemp);

	if (len % 2 != 0)
		return -1;
	int StrSize = len / 2;
	memcpy(String, ChartoUChar(CharTemp), StrSize);
	return StrSize;
}

// ޸CEditֵʾĸʽ
CString CShare::TxtChange(CEdit *pEdit, int &nStart, int &nEnd)
{
    char	temp[2048];
	CString	str;
	int		len;

    pEdit->GetSel(nStart, nEnd);
	pEdit->GetWindowText(str);
	strcpy(temp, str);
	len = str.GetLength();
	
	for (int i = 0, j = 0; i < len; i++) {   
		switch(temp[i]) {
		case 0x30:
		case 0x31:
		case 0x32:
		case 0x33:
		case 0x34:
		case 0x35:
		case 0x36:
		case 0x37:
		case 0x38:
		case 0x39:
		case 0x41:
		case 0x42:
		case 0x43:
		case 0x44:
		case 0x45:
		case 0x46:
			temp[j++] = temp[i];
			break;
		case 0x61:
		case 0x62:
		case 0x63:
		case 0x64:
		case 0x65:
		case 0x66:
			temp[j++] = temp[i] - 0x20;
			break;
		default:
			nStart--;
			nEnd--;
			break;
		}
	}

	temp[j] = 0x00;
	len = strlen(temp);
    str = "";
    for (i = 0; i < len; i++) {
		str += temp[i++];
		str += temp[i];
		if ( (len - i) > 1) {
			str += " ";
			nStart++;
			nEnd++;
		}
	}
	return str;
}
